/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.TypeCache;
import org.snapscript.core.TypeCastChecker;
import org.snapscript.core.TypeExtractor;
import org.snapscript.core.TypeLoader;
import org.snapscript.core.TypeVerifier;
import org.snapscript.core.convert.AnyConverter;
import org.snapscript.core.convert.ArrayConverter;
import org.snapscript.core.convert.AtomicIntegerConverter;
import org.snapscript.core.convert.AtomicLongConverter;
import org.snapscript.core.convert.BigDecimalConverter;
import org.snapscript.core.convert.BigIntegerConverter;
import org.snapscript.core.convert.BooleanConverter;
import org.snapscript.core.convert.ByteConverter;
import org.snapscript.core.convert.CharacterConverter;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.DoubleConverter;
import org.snapscript.core.convert.EnumConverter;
import org.snapscript.core.convert.FloatConverter;
import org.snapscript.core.convert.IntegerConverter;
import org.snapscript.core.convert.LongConverter;
import org.snapscript.core.convert.NullConverter;
import org.snapscript.core.convert.NumberConverter;
import org.snapscript.core.convert.ObjectConverter;
import org.snapscript.core.convert.ProxyWrapper;
import org.snapscript.core.convert.ScopeConverter;
import org.snapscript.core.convert.ShortConverter;
import org.snapscript.core.convert.StringConverter;

public class ConstraintMatcher {
    private final TypeCache<ConstraintConverter> converters = new TypeCache();
    private final ConstraintConverter converter;
    private final TypeExtractor extractor;
    private final TypeVerifier comparator;
    private final TypeCastChecker checker;
    private final ProxyWrapper wrapper;

    public ConstraintMatcher(TypeLoader loader, ProxyWrapper wrapper) {
        this.extractor = new TypeExtractor(loader);
        this.checker = new TypeCastChecker(this, this.extractor, loader);
        this.comparator = new TypeVerifier(loader, this.checker);
        this.converter = new NullConverter();
        this.wrapper = wrapper;
    }

    public ConstraintConverter match(Type type) throws Exception {
        if (type != null) {
            ConstraintConverter converter = this.converters.fetch(type);
            if (converter == null) {
                converter = this.resolve(type);
                this.converters.cache(type, converter);
            }
            return converter;
        }
        return this.converter;
    }

    private ConstraintConverter resolve(Type type) throws Exception {
        if (this.comparator.isSame(type, Object.class)) {
            return new AnyConverter(this.wrapper);
        }
        if (this.comparator.isSame(type, Double.TYPE)) {
            return new DoubleConverter(type);
        }
        if (this.comparator.isSame(type, Float.TYPE)) {
            return new FloatConverter(type);
        }
        if (this.comparator.isSame(type, Integer.TYPE)) {
            return new IntegerConverter(type);
        }
        if (this.comparator.isSame(type, Long.TYPE)) {
            return new LongConverter(type);
        }
        if (this.comparator.isSame(type, Short.TYPE)) {
            return new ShortConverter(type);
        }
        if (this.comparator.isSame(type, Byte.TYPE)) {
            return new ByteConverter(type);
        }
        if (this.comparator.isSame(type, Character.TYPE)) {
            return new CharacterConverter(type);
        }
        if (this.comparator.isSame(type, Boolean.TYPE)) {
            return new BooleanConverter(type);
        }
        if (this.comparator.isSame(type, Number.class)) {
            return new NumberConverter(type);
        }
        if (this.comparator.isSame(type, Double.class)) {
            return new DoubleConverter(type);
        }
        if (this.comparator.isSame(type, Float.class)) {
            return new FloatConverter(type);
        }
        if (this.comparator.isSame(type, Integer.class)) {
            return new IntegerConverter(type);
        }
        if (this.comparator.isSame(type, Long.class)) {
            return new LongConverter(type);
        }
        if (this.comparator.isSame(type, Short.class)) {
            return new ShortConverter(type);
        }
        if (this.comparator.isSame(type, Byte.class)) {
            return new ByteConverter(type);
        }
        if (this.comparator.isSame(type, Character.class)) {
            return new CharacterConverter(type);
        }
        if (this.comparator.isSame(type, Boolean.class)) {
            return new BooleanConverter(type);
        }
        if (this.comparator.isSame(type, BigDecimal.class)) {
            return new BigDecimalConverter(type);
        }
        if (this.comparator.isSame(type, BigInteger.class)) {
            return new BigIntegerConverter(type);
        }
        if (this.comparator.isSame(type, AtomicLong.class)) {
            return new AtomicLongConverter(type);
        }
        if (this.comparator.isSame(type, AtomicInteger.class)) {
            return new AtomicIntegerConverter(type);
        }
        if (this.comparator.isSame(type, String.class)) {
            return new StringConverter();
        }
        if (this.comparator.isLike(type, Scope.class)) {
            return new ScopeConverter();
        }
        if (this.comparator.isLike(type, Enum.class)) {
            return new EnumConverter(type);
        }
        if (this.comparator.isArray(type)) {
            return new ArrayConverter(this, this.wrapper, type);
        }
        return new ObjectConverter(this.extractor, this.checker, this.wrapper, type);
    }
}

