/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.util.List;
import org.snapscript.core.Type;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.ConstraintMatcher;
import org.snapscript.core.convert.Score;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.Signature;

public class FunctionComparator {
    private final ConstraintMatcher matcher;

    public FunctionComparator(ConstraintMatcher matcher) {
        this.matcher = matcher;
    }

    public Score compare(Function actual, List<Function> require) throws Exception {
        String name = actual.getName();
        for (Function function : require) {
            Score compare;
            String match = function.getName();
            if (!name.equals(match) || (compare = this.compare(actual, function)) == Score.INVALID) continue;
            return compare;
        }
        return Score.INVALID;
    }

    public Score compare(Function actual, Function require) throws Exception {
        Score score;
        Signature actualSignature = actual.getSignature();
        Signature requireSignature = require.getSignature();
        List<Parameter> actualParameters = actualSignature.getParameters();
        List<Parameter> requireParameters = requireSignature.getParameters();
        int actualSize = actualParameters.size();
        int requireSize = requireParameters.size();
        boolean actualVariable = actualSignature.isVariable();
        if (actualSize == requireSize && (score = this.compare(actualParameters, requireParameters)).compareTo(Score.INVALID) > 0) {
            return score;
        }
        if (actualVariable && actualSize <= requireSize && (score = this.compare(actualParameters, requireParameters)).compareTo(Score.INVALID) > 0) {
            return score;
        }
        return Score.INVALID;
    }

    private Score compare(List<Parameter> actual, List<Parameter> require) throws Exception {
        int requireSize = require.size();
        if (requireSize > 0) {
            Score total = Score.INVALID;
            int j = 0;
            for (int i = 0; i < requireSize; ++i) {
                Parameter requireParameter;
                Parameter actualParameter = actual.get(j);
                Score score = this.compare(actualParameter, requireParameter = require.get(i));
                if (score.compareTo(Score.INVALID) <= 0) {
                    return Score.INVALID;
                }
                total = Score.sum(total, score);
                if (actualParameter.isVariable()) continue;
                ++j;
            }
            return total;
        }
        return Score.EXACT;
    }

    private Score compare(Parameter actual, Parameter require) throws Exception {
        Type actualType = actual.getType();
        Type constraintType = require.getType();
        ConstraintConverter converter = this.matcher.match(constraintType);
        Score score = converter.score(actualType);
        if (actual.isVariable()) {
            if (score.compareTo(Score.INVALID) <= 0) {
                return Score.INVALID;
            }
            return Score.POSSIBLE;
        }
        return score;
    }
}

