/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.snapscript.core.Context;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Result;
import org.snapscript.core.Scope;
import org.snapscript.core.Transient;
import org.snapscript.core.Type;
import org.snapscript.core.Value;
import org.snapscript.core.bind.FunctionBinder;
import org.snapscript.core.convert.ProxyArgumentExtractor;
import org.snapscript.core.convert.ProxyHandler;
import org.snapscript.core.convert.ProxyWrapper;
import org.snapscript.core.function.Function;

public class FunctionProxyHandler
implements ProxyHandler {
    private final ProxyArgumentExtractor extractor;
    private final ProxyWrapper wrapper;
    private final Function function;
    private final Context context;
    private final Value value;

    public FunctionProxyHandler(ProxyWrapper wrapper, Context context, Function function) {
        this.extractor = new ProxyArgumentExtractor(wrapper);
        this.value = new Transient(function);
        this.function = function;
        this.wrapper = wrapper;
        this.context = context;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Object[] convert = this.extractor.extract(arguments);
        String name = method.getName();
        int width = convert.length;
        if (name.equals("hashCode")) {
            if (width != 0) {
                throw new InternalStateException("Closure 'hashCode' does not accept " + width + " arguments");
            }
            return this.function.hashCode();
        }
        if (name.equals("toString")) {
            if (width != 0) {
                throw new InternalStateException("Closure 'toString' does not accept " + width + " arguments");
            }
            return this.function.toString();
        }
        if (name.equals("equals")) {
            if (width != 1) {
                throw new InternalStateException("Closure 'equals' does not accept " + width + " arguments");
            }
            return this.function.equals(convert[0]);
        }
        if (convert.length > 0) {
            return this.invoke(proxy, name, convert, arguments);
        }
        return this.invoke(proxy, name, convert, convert);
    }

    private Object invoke(Object proxy, String name, Object[] convert, Object[] arguments) throws Throwable {
        Callable<Result> call = this.resolve(proxy, name, convert, arguments);
        int width = arguments.length;
        if (call == null) {
            throw new InternalStateException("Closure not matched with " + width + " arguments");
        }
        Result result = call.call();
        Object data = result.getValue();
        return this.wrapper.toProxy(data);
    }

    private Callable<Result> resolve(Object proxy, String name, Object[] convert, Object[] arguments) throws Throwable {
        Scope scope;
        Callable<Result> call;
        Type type = this.function.getType();
        FunctionBinder binder = this.context.getBinder();
        if (type != null && (call = binder.bind(scope = type.getScope(), proxy, name, arguments)) != null) {
            return call;
        }
        return binder.bind(this.value, convert);
    }

    @Override
    public Function extract() {
        return this.function;
    }
}

