/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.snapscript.core.Any;
import org.snapscript.core.Context;
import org.snapscript.core.Module;
import org.snapscript.core.Scope;
import org.snapscript.core.Type;
import org.snapscript.core.TypeCache;
import org.snapscript.core.TypeExtractor;

public class InterfaceCollector {
    private final TypeCache<Class[]> cache = new TypeCache();
    private final Class[] include;
    private final Class[] empty = new Class[0];

    public InterfaceCollector(Class ... include) {
        this.include = include;
    }

    public Class[] collect(Scope scope) {
        Type type = scope.getType();
        if (type != null) {
            Class[] interfaces = this.cache.fetch(type);
            if (interfaces == null) {
                Set<Class> types = this.traverse(type);
                Class[] result = types.toArray(this.empty);
                this.cache.cache(type, result);
                return result;
            }
            return interfaces;
        }
        return this.empty;
    }

    public Class[] filter(Class ... types) {
        if (types.length > 0) {
            HashSet<Class> interfaces = new HashSet<Class>();
            for (Class entry : types) {
                if (entry == null || !entry.isInterface()) continue;
                interfaces.add(entry);
            }
            return interfaces.toArray(this.empty);
        }
        return this.empty;
    }

    private Set<Class> traverse(Type type) {
        Module module = type.getModule();
        Context context = module.getContext();
        TypeExtractor extractor = context.getExtractor();
        Set<Type> types = extractor.getTypes(type);
        if (!types.isEmpty()) {
            HashSet<Class> interfaces = new HashSet<Class>();
            for (Type entry : types) {
                Class part = entry.getType();
                if (part == null || !part.isInterface()) continue;
                interfaces.add(part);
            }
            for (Class entry : this.include) {
                interfaces.add(entry);
            }
            interfaces.add(Any.class);
            return interfaces;
        }
        return Collections.singleton(Any.class);
    }
}

