/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.snapscript.core.InternalArgumentException;
import org.snapscript.core.Type;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.NumberMatcher;
import org.snapscript.core.convert.NumberType;
import org.snapscript.core.convert.Score;
import org.snapscript.core.convert.ScoreChecker;

public class NumberConverter
extends ConstraintConverter {
    private static final Class[] NUMBER_TYPES = new Class[]{Integer.class, Long.class, Double.class, Float.class, Short.class, Byte.class, BigInteger.class, AtomicInteger.class, AtomicLong.class, BigDecimal.class};
    private static final Score[] NUMBER_SCORES = new Score[]{Score.SIMILAR, Score.SIMILAR, Score.SIMILAR, Score.SIMILAR, Score.SIMILAR, Score.SIMILAR, Score.SIMILAR, Score.SIMILAR, Score.SIMILAR, Score.SIMILAR};
    protected final NumberMatcher matcher;
    protected final ScoreChecker checker;
    protected final Type type;

    public NumberConverter(Type type) {
        this(type, NUMBER_TYPES, NUMBER_SCORES);
    }

    public NumberConverter(Type type, Class[] types, Score[] scores) {
        this.checker = new ScoreChecker(types, scores);
        this.matcher = new NumberMatcher();
        this.type = type;
    }

    @Override
    public Score score(Type actual) throws Exception {
        if (actual != null) {
            Class real = actual.getType();
            if (real != null) {
                Score score = this.checker.score(real);
                if (score != null) {
                    return score;
                }
                if (real == String.class) {
                    return Score.POSSIBLE;
                }
            }
            return Score.INVALID;
        }
        return Score.POSSIBLE;
    }

    @Override
    public Score score(Object value) throws Exception {
        Class require = this.type.getType();
        if (value != null) {
            Class<?> actual = value.getClass();
            Score score = this.checker.score(actual);
            if (score == null) {
                String text;
                NumberType type;
                if (actual == String.class && (type = this.matcher.matchNumber(text = String.valueOf(value))).isDecimal()) {
                    return Score.POSSIBLE;
                }
                return Score.INVALID;
            }
            return score;
        }
        if (require.isPrimitive()) {
            return Score.INVALID;
        }
        return Score.POSSIBLE;
    }

    @Override
    public Object convert(Object value) throws Exception {
        Class require = this.type.getType();
        if (value != null) {
            Class<?> actual = value.getClass();
            if (actual == String.class) {
                return this.convert(require, (String)value);
            }
            Class<?> parent = actual.getSuperclass();
            if (parent == Number.class) {
                return this.convert(require, (Number)value);
            }
            throw new InternalArgumentException("Conversion from " + actual + " to " + require + " is not possible");
        }
        if (require.isPrimitive()) {
            throw new InternalArgumentException("Invalid conversion from null to primitive number");
        }
        return null;
    }
}

