/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import org.snapscript.core.convert.NumberType;

public class NumberMatcher {
    public NumberType matchNumber(String text) {
        int length;
        if (text != null && (length = text.length()) > 0) {
            char second;
            char first = text.charAt(0);
            if (first == '-' || first == '+') {
                char second2;
                if (length > 1 && (second2 = text.charAt(2)) == 'x') {
                    return this.matchHexidecimal(text, 3, length);
                }
                return this.matchDecimal(text, 1, length);
            }
            if (first == '0' && length > 1 && (second = text.charAt(1)) == 'x') {
                return this.matchHexidecimal(text, 2, length);
            }
            return this.matchDecimal(text, 0, length);
        }
        return NumberType.NONE;
    }

    private NumberType matchHexidecimal(String text, int index, int length) {
        while (index < length) {
            char value;
            if ((value = text.charAt(index++)) >= '0' && value <= '9' || value >= 'a' && value <= 'f' || value >= 'A' && value <= 'F') continue;
            return NumberType.NONE;
        }
        return NumberType.HEXIDECIMAL;
    }

    private NumberType matchDecimal(String text, int index, int length) {
        char value;
        while (index < length) {
            if ((value = text.charAt(index++)) == '-' || value == '+') {
                if (index <= 1) continue;
                return NumberType.NONE;
            }
            if (value >= '0' && value <= '9') continue;
            if (value == '.') break;
            return NumberType.NONE;
        }
        if (index < length) {
            while (index < length) {
                if ((value = text.charAt(index++)) >= '0' && value <= '9') continue;
                if (value == 'e' || value == 'E') break;
                return NumberType.NONE;
            }
            int start = index + 1;
            while (index < length) {
                char value2;
                if (!((value2 = text.charAt(index++)) == '-' || value2 == '+' ? start > index : value2 < '0' || value2 > '9')) continue;
                return NumberType.NONE;
            }
        }
        return NumberType.DECIMAL;
    }
}

