/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import org.snapscript.core.Type;
import org.snapscript.core.TypeCastChecker;
import org.snapscript.core.TypeExtractor;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.ProxyWrapper;
import org.snapscript.core.convert.Score;

public class ObjectConverter
extends ConstraintConverter {
    private final TypeCastChecker checker;
    private final TypeExtractor extractor;
    private final ProxyWrapper wrapper;
    private final Type constraint;

    public ObjectConverter(TypeExtractor extractor, TypeCastChecker checker, ProxyWrapper wrapper, Type constraint) {
        this.constraint = constraint;
        this.extractor = extractor;
        this.wrapper = wrapper;
        this.checker = checker;
    }

    @Override
    public Score score(Type actual) throws Exception {
        if (actual != null) {
            Class real = actual.getType();
            Class require = this.constraint.getType();
            if (require == real) {
                return Score.EXACT;
            }
            return this.checker.cast(actual, this.constraint);
        }
        return Score.EXACT;
    }

    @Override
    public Score score(Object value) throws Exception {
        Type match = this.extractor.getType(value);
        if (match != null) {
            if (match.equals(this.constraint)) {
                return Score.EXACT;
            }
            return this.checker.cast(match, this.constraint, value);
        }
        return Score.EXACT;
    }

    @Override
    public Object convert(Object object) {
        Class require = this.constraint.getType();
        if (require != null) {
            return this.wrapper.toProxy(object, require);
        }
        return object;
    }
}

