/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.snapscript.core.Any;
import org.snapscript.core.Context;
import org.snapscript.core.ContextClassLoader;
import org.snapscript.core.Scope;
import org.snapscript.core.convert.FunctionProxyHandler;
import org.snapscript.core.convert.InterfaceCollector;
import org.snapscript.core.convert.ProxyWrapper;
import org.snapscript.core.convert.ScopeProxyHandler;
import org.snapscript.core.convert.TraceProxyHandler;
import org.snapscript.core.function.Function;

public class ProxyFactory {
    private final InterfaceCollector collector;
    private final ProxyWrapper wrapper;
    private final ClassLoader loader = new ContextClassLoader(Any.class);
    private final Context context;

    public ProxyFactory(ProxyWrapper wrapper, Context context) {
        this.collector = new InterfaceCollector(new Class[0]);
        this.wrapper = wrapper;
        this.context = context;
    }

    public Object create(Scope scope) {
        Class[] interfaces = this.collector.collect(scope);
        if (interfaces.length > 0) {
            ScopeProxyHandler handler = new ScopeProxyHandler(this.wrapper, this.context, scope);
            TraceProxyHandler tracer = new TraceProxyHandler(handler, this.context, scope);
            return Proxy.newProxyInstance(this.loader, interfaces, (InvocationHandler)tracer);
        }
        return scope;
    }

    public Object create(Function function, Class ... require) {
        Class[] interfaces = this.collector.filter(require);
        if (interfaces.length > 0) {
            FunctionProxyHandler handler = new FunctionProxyHandler(this.wrapper, this.context, function);
            return Proxy.newProxyInstance(this.loader, interfaces, (InvocationHandler)handler);
        }
        return function;
    }
}

