/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.snapscript.core.Context;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Result;
import org.snapscript.core.Scope;
import org.snapscript.core.bind.FunctionBinder;
import org.snapscript.core.convert.ProxyArgumentExtractor;
import org.snapscript.core.convert.ProxyHandler;
import org.snapscript.core.convert.ProxyWrapper;

public class ScopeProxyHandler
implements ProxyHandler {
    private final ProxyArgumentExtractor extractor;
    private final Context context;
    private final Scope scope;

    public ScopeProxyHandler(ProxyWrapper wrapper, Context context, Scope scope) {
        this.extractor = new ProxyArgumentExtractor(wrapper);
        this.context = context;
        this.scope = scope;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Object[] convert;
        String name = method.getName();
        FunctionBinder binder = this.context.getBinder();
        Callable<Result> call = binder.bind(this.scope, (Object)this.scope, name, convert = this.extractor.extract(arguments));
        if (call == null) {
            throw new InternalStateException("Method '" + name + "' not found");
        }
        Result result = call.call();
        Object data = result.getValue();
        return data;
    }

    @Override
    public Scope extract() {
        return this.scope;
    }
}

