/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.snapscript.core.Context;
import org.snapscript.core.Module;
import org.snapscript.core.Path;
import org.snapscript.core.Result;
import org.snapscript.core.Scope;
import org.snapscript.core.convert.ProxyHandler;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceType;

public class TraceProxyHandler
implements ProxyHandler {
    private final InvocationHandler delegate;
    private final Context context;
    private final Scope scope;

    public TraceProxyHandler(InvocationHandler delegate, Context context, Scope scope) {
        this.context = context;
        this.delegate = delegate;
        this.scope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] list) throws Throwable {
        Module module = this.scope.getModule();
        Path path = module.getPath();
        Trace trace = TraceType.getNative(module, path);
        TraceInterceptor interceptor = this.context.getInterceptor();
        ErrorHandler handler = this.context.getHandler();
        try {
            interceptor.before(this.scope, trace);
            Object object = this.delegate.invoke(proxy, method, list);
            return object;
        }
        catch (Exception cause) {
            Result result = handler.throwInternal(this.scope, cause);
            return result;
        }
        finally {
            interceptor.after(this.scope, trace);
        }
    }

    @Override
    public Scope extract() {
        return this.scope;
    }
}

