/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.convert;

import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.Score;
import org.snapscript.core.function.ArgumentConverter;

public class VariableArgumentConverter
implements ArgumentConverter {
    private final ConstraintConverter[] converters;

    public VariableArgumentConverter(ConstraintConverter[] converters) {
        this.converters = converters;
    }

    @Override
    public Score score(Object ... list) throws Exception {
        if (list.length > 0) {
            Score score;
            Object value;
            ConstraintConverter converter;
            int i;
            int require = this.converters.length;
            int start = require - 1;
            int remaining = list.length - start;
            if (remaining < 0) {
                return Score.INVALID;
            }
            Score total = Score.INVALID;
            for (i = 0; i < start; ++i) {
                converter = this.converters[i];
                value = list[i];
                score = converter.score(value);
                if (score.compareTo(Score.INVALID) == 0) {
                    return Score.INVALID;
                }
                total = Score.sum(total, score);
            }
            if (remaining > 0) {
                for (i = 0; i < remaining; ++i) {
                    converter = this.converters[require - 1];
                    value = list[i + start];
                    score = converter.score(value);
                    if (score.compareTo(Score.INVALID) == 0) {
                        return Score.INVALID;
                    }
                    total = Score.sum(total, score);
                }
            }
            return total;
        }
        if (this.converters.length == 1) {
            return Score.SIMILAR;
        }
        return Score.INVALID;
    }

    @Override
    public Object[] convert(Object ... list) throws Exception {
        if (list.length > 0) {
            Object value;
            ConstraintConverter converter;
            int i;
            int require = this.converters.length;
            int start = require - 1;
            int remaining = list.length - start;
            for (i = 0; i < start; ++i) {
                converter = this.converters[i];
                value = list[i];
                list[i] = converter.convert(value);
            }
            if (remaining > 0) {
                for (i = 0; i < remaining; ++i) {
                    converter = this.converters[require - 1];
                    value = list[i + start];
                    list[i + start] = converter.convert(value);
                }
            }
        }
        return list;
    }
}

