/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.define;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.snapscript.common.CompoundIterator;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.State;
import org.snapscript.core.Value;
import org.snapscript.core.define.Instance;

public class InstanceState
implements State {
    private final Map<String, Value> values = new HashMap<String, Value>();
    private final Instance instance;

    public InstanceState(Instance instance) {
        this.instance = instance;
    }

    @Override
    public Iterator<String> iterator() {
        Set<String> keys = this.values.keySet();
        Iterator<String> inner = keys.iterator();
        if (this.instance != null) {
            State state = this.instance.getState();
            Iterator outer = state.iterator();
            return new CompoundIterator<String>(inner, outer);
        }
        return inner;
    }

    @Override
    public Value get(String name) {
        Value value = this.values.get(name);
        if (value == null) {
            State state = this.instance.getState();
            if (state == null) {
                throw new InternalStateException("Scope for '" + name + "' does not exist");
            }
            value = state.get(name);
        }
        return value;
    }

    @Override
    public void add(String name, Value value) {
        Value variable = this.values.get(name);
        if (variable != null) {
            throw new InternalStateException("Variable '" + name + "' already exists");
        }
        this.values.put(name, value);
    }

    public String toString() {
        return String.valueOf(this.values);
    }
}

