/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.error;

import org.snapscript.core.Result;
import org.snapscript.core.Scope;
import org.snapscript.core.error.ExternalErrorHandler;
import org.snapscript.core.error.InternalError;
import org.snapscript.core.error.InternalErrorHandler;
import org.snapscript.core.stack.ThreadStack;

public class ErrorHandler {
    private final ExternalErrorHandler external;
    private final InternalErrorHandler internal;

    public ErrorHandler(ThreadStack stack) {
        this(stack, true);
    }

    public ErrorHandler(ThreadStack stack, boolean replace) {
        this.internal = new InternalErrorHandler(stack, replace);
        this.external = new ExternalErrorHandler();
    }

    public Result throwInternal(Scope scope, Object cause) {
        if (InternalError.class.isInstance(cause)) {
            throw (InternalError)cause;
        }
        return this.internal.throwInternal(scope, cause);
    }

    public Result throwExternal(Scope scope, Throwable cause) throws Exception {
        if (InternalError.class.isInstance(cause)) {
            InternalError error = (InternalError)cause;
            Object original = error.getValue();
            if (Exception.class.isInstance(original)) {
                throw (Exception)original;
            }
            return this.external.throwExternal(scope, original);
        }
        return this.external.throwExternal(scope, cause);
    }
}

