/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.error;

import org.snapscript.core.error.InternalError;
import org.snapscript.core.stack.ThreadStack;

public class InternalErrorBuilder {
    private final ThreadStack stack;
    private final boolean replace;

    public InternalErrorBuilder(ThreadStack stack) {
        this(stack, true);
    }

    public InternalErrorBuilder(ThreadStack stack, boolean replace) {
        this.replace = replace;
        this.stack = stack;
    }

    public InternalError create(Object value) {
        Throwable cause;
        StackTraceElement[] trace;
        InternalError error = new InternalError(value);
        if (this.replace) {
            if (Throwable.class.isInstance(value)) {
                Throwable cause2 = (Throwable)value;
                StackTraceElement[] trace2 = this.stack.build(cause2);
                if (trace2.length > 0) {
                    cause2.setStackTrace(trace2);
                    error.setStackTrace(trace2);
                }
            } else {
                StackTraceElement[] trace3 = this.stack.build();
                if (trace3.length > 0) {
                    error.setStackTrace(trace3);
                }
            }
        } else if (Throwable.class.isInstance(value) && (trace = (cause = (Throwable)value).getStackTrace()).length > 0) {
            error.setStackTrace(trace);
        }
        return error;
    }
}

