/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.extend;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.snapscript.core.InternalException;
import org.snapscript.core.Module;
import org.snapscript.core.Type;
import org.snapscript.core.TypeLoader;
import org.snapscript.core.extend.FunctionExtractor;
import org.snapscript.core.function.Function;

public class ExtensionRegistry {
    private final Map<Class, Class> extensions = new ConcurrentHashMap<Class, Class>();
    private final FunctionExtractor extractor;
    private final TypeLoader loader;

    public ExtensionRegistry(TypeLoader loader) {
        this.extractor = new FunctionExtractor(loader);
        this.loader = loader;
    }

    public void register(Class type, Class extension) {
        this.extensions.put(type, extension);
    }

    public List<Function> extract(Class type) {
        Class extension = this.extensions.get(type);
        if (extension != null) {
            try {
                Object instance = extension.newInstance();
                Type match = this.loader.loadType(type);
                Module module = match.getModule();
                return this.extractor.extract(module, type, instance);
            }
            catch (Exception e) {
                throw new InternalException("Could not extend " + type, e);
            }
        }
        return Collections.emptyList();
    }
}

