/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import org.snapscript.core.Module;
import org.snapscript.core.Type;
import org.snapscript.core.function.Signature;
import org.snapscript.core.function.SignatureDescription;

public class FunctionDescription {
    private final SignatureDescription description;
    private final String name;
    private final Type type;

    public FunctionDescription(Signature signature, Type type, String name) {
        this(signature, type, name, 0);
    }

    public FunctionDescription(Signature signature, Type type, String name, int start) {
        this.description = new SignatureDescription(signature, start);
        this.name = name;
        this.type = type;
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        if (this.type != null) {
            String name = this.type.getName();
            Module module = this.type.getModule();
            String prefix = module.getName();
            builder.append(prefix);
            builder.append(".");
            if (name != null) {
                builder.append(name);
                builder.append(".");
            }
        }
        builder.append(this.name);
        builder.append(this.description);
        return builder.toString();
    }

    public String toString() {
        return this.getDescription();
    }
}

