/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.Type;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.FunctionDescription;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.Signature;

public class InvocationFunction
implements Function {
    private final FunctionDescription description;
    private final List<Annotation> annotations;
    private final Invocation invocation;
    private final Signature signature;
    private final Type constraint;
    private final Type parent;
    private final String name;
    private final int modifiers;

    public InvocationFunction(Signature signature, Invocation invocation, Type parent, Type constraint, String name) {
        this(signature, invocation, parent, constraint, name, 0);
    }

    public InvocationFunction(Signature signature, Invocation invocation, Type parent, Type constraint, String name, int modifiers) {
        this(signature, invocation, parent, constraint, name, modifiers, 0);
    }

    public InvocationFunction(Signature signature, Invocation invocation, Type parent, Type constraint, String name, int modifiers, int start) {
        this.description = new FunctionDescription(signature, parent, name, start);
        this.annotations = new ArrayList<Annotation>();
        this.invocation = invocation;
        this.constraint = constraint;
        this.signature = signature;
        this.modifiers = modifiers;
        this.parent = parent;
        this.name = name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public Type getType() {
        return this.parent;
    }

    @Override
    public Type getHandle() {
        return this.signature.getDefinition();
    }

    @Override
    public Type getConstraint() {
        return this.constraint;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Invocation getInvocation() {
        return this.invocation;
    }

    @Override
    public String getDescription() {
        return this.description.getDescription();
    }

    @Override
    public String toString() {
        return this.description.toString();
    }
}

