/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import java.lang.reflect.Array;
import java.util.List;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.Signature;

public class SignatureAligner {
    private final Signature signature;

    public SignatureAligner(Signature signature) {
        this.signature = signature;
    }

    public Object[] align(Object ... list) throws Exception {
        if (this.signature.isVariable()) {
            int i;
            List<Parameter> parameters = this.signature.getParameters();
            int length = parameters.size();
            int start = length - 1;
            int remaining = list.length - start;
            if (remaining > 0) {
                Object[] array = new Object[remaining];
                for (i = 0; i < remaining; ++i) {
                    try {
                        Array.set(array, i, list[i + start]);
                        continue;
                    }
                    catch (Exception e) {
                        throw new InternalStateException("Invalid argument at " + i + " for" + this.signature, e);
                    }
                }
                list[start] = array;
            }
            Object[] copy = new Object[length];
            for (i = 0; i < length; ++i) {
                copy[i] = list[i];
            }
            return copy;
        }
        return list;
    }
}

