/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import java.util.List;
import org.snapscript.core.Type;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.function.Signature;

public class SignatureDescription {
    private final Signature signature;
    private final int start;

    public SignatureDescription(Signature signature) {
        this(signature, 0);
    }

    public SignatureDescription(Signature signature, int start) {
        this.signature = signature;
        this.start = start;
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        if (this.signature != null) {
            List<Parameter> parameters = this.signature.getParameters();
            int size = parameters.size();
            for (int i = this.start; i < size; ++i) {
                Parameter parameter = parameters.get(i);
                Type type = parameter.getType();
                String name = parameter.getName();
                if (i > this.start) {
                    builder.append(", ");
                }
                builder.append(name);
                if (parameter.isVariable()) {
                    builder.append("...");
                }
                if (type == null) continue;
                String constraint = type.getName();
                builder.append(": ");
                builder.append(constraint);
            }
        }
        builder.append(")");
        return builder.toString();
    }

    public String toString() {
        return this.getDescription();
    }
}

