/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.function;

import org.snapscript.core.InternalStateException;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Type;
import org.snapscript.core.TypeFactory;
import org.snapscript.core.Value;
import org.snapscript.core.function.Accessor;
import org.snapscript.core.function.ScopeAccessor;

public class StaticAccessor
implements Accessor {
    private final TypeFactory factory;
    private final Accessor accessor;
    private final Scope scope;
    private final String name;
    private final Type type;

    public StaticAccessor(TypeFactory factory, Scope scope, Type type, String name) {
        this.accessor = new ScopeAccessor(name);
        this.factory = factory;
        this.scope = scope;
        this.name = name;
        this.type = type;
    }

    public Object getValue(Object source) {
        try {
            State state = this.scope.getState();
            Value field = state.get(this.name);
            if (field == null) {
                this.factory.compile(this.scope, this.type);
            }
        }
        catch (Exception e) {
            throw new InternalStateException("Static reference of '" + this.name + "' in '" + this.type + "' failed", e);
        }
        return this.accessor.getValue(this.scope);
    }

    public void setValue(Object source, Object value) {
        try {
            State state = this.scope.getState();
            Value field = state.get(this.name);
            if (field == null) {
                this.factory.compile(this.scope, this.type);
            }
        }
        catch (Exception e) {
            throw new InternalStateException("Static reference of '" + this.name + "' in '" + this.type + "' failed", e);
        }
        this.accessor.setValue(this.scope, value);
    }
}

