/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.index;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.Type;
import org.snapscript.core.index.TypeIndexer;

public class ClassHierarchyIndexer {
    private final TypeIndexer indexer;

    public ClassHierarchyIndexer(TypeIndexer indexer) {
        this.indexer = indexer;
    }

    public List<Type> index(Class source) throws Exception {
        ArrayList<Type> hierarchy = new ArrayList<Type>();
        if (source == Object.class) {
            Type base = this.indexer.defineType("default", "Any");
            if (base != null) {
                hierarchy.add(base);
            }
        } else {
            Type type;
            Class<?>[] interfaces = source.getInterfaces();
            Class base = source.getSuperclass();
            if (base != null && (type = this.indexer.loadType(base)) != null) {
                hierarchy.add(type);
            }
            for (Class<?> entry : interfaces) {
                Type type2 = this.indexer.loadType(entry);
                if (type2 == null) continue;
                hierarchy.add(type2);
            }
        }
        return hierarchy;
    }
}

