/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.index;

import java.util.List;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.Type;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.function.Function;
import org.snapscript.core.index.ClassIndexer;
import org.snapscript.core.index.ClassType;
import org.snapscript.core.property.Property;

public class ClassIndex {
    private List<Annotation> annotations;
    private List<Property> properties;
    private List<Function> functions;
    private ClassIndexer indexer;
    private List<Type> types;
    private ClassType require;
    private Module module;
    private Type outer;
    private Type entry;

    public ClassIndex(ClassIndexer indexer, ClassType require) {
        this.indexer = indexer;
        this.require = require;
    }

    public List<Annotation> getAnnotations() {
        if (this.annotations == null) {
            try {
                this.annotations = this.indexer.indexAnnotations(this.require);
            }
            catch (Exception e) {
                throw new InternalStateException("Could not index " + this.require, e);
            }
        }
        return this.annotations;
    }

    public List<Property> getProperties() {
        if (this.properties == null) {
            try {
                this.properties = this.indexer.indexProperties(this.require);
            }
            catch (Exception e) {
                throw new InternalStateException("Could not index " + this.require, e);
            }
        }
        return this.properties;
    }

    public List<Function> getFunctions() {
        if (this.functions == null) {
            try {
                this.functions = this.indexer.indexFunctions(this.require);
            }
            catch (Exception e) {
                throw new InternalStateException("Could not index " + this.require, e);
            }
        }
        return this.functions;
    }

    public List<Type> getTypes() {
        if (this.types == null) {
            try {
                this.types = this.indexer.indexTypes(this.require);
            }
            catch (Exception e) {
                throw new InternalStateException("Could not index " + this.require, e);
            }
        }
        return this.types;
    }

    public Module getModule() {
        if (this.module == null) {
            try {
                this.module = this.indexer.indexModule(this.require);
            }
            catch (Exception e) {
                throw new InternalStateException("Could not index " + this.require, e);
            }
        }
        return this.module;
    }

    public Type getOuter() {
        if (this.entry == null) {
            try {
                this.entry = this.indexer.indexOuter(this.require);
            }
            catch (Exception e) {
                throw new InternalStateException("Could not index " + this.require, e);
            }
        }
        return this.entry;
    }

    public Type getEntry() {
        if (this.entry == null) {
            try {
                this.entry = this.indexer.indexEntry(this.require);
            }
            catch (Exception e) {
                throw new InternalStateException("Could not index " + this.require, e);
            }
        }
        return this.entry;
    }
}

