/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.index;

import java.util.List;
import org.snapscript.core.InternalArgumentException;
import org.snapscript.core.Module;
import org.snapscript.core.ModuleRegistry;
import org.snapscript.core.PrimitivePromoter;
import org.snapscript.core.Type;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.annotation.AnnotationExtractor;
import org.snapscript.core.extend.ClassExtender;
import org.snapscript.core.function.Function;
import org.snapscript.core.index.ClassHierarchyIndexer;
import org.snapscript.core.index.ClassType;
import org.snapscript.core.index.FunctionIndexer;
import org.snapscript.core.index.PropertyIndexer;
import org.snapscript.core.index.TypeIndexer;
import org.snapscript.core.link.ImportScanner;
import org.snapscript.core.property.Property;

public class ClassIndexer {
    private final ClassHierarchyIndexer hierarchy;
    private final AnnotationExtractor extractor;
    private final FunctionIndexer functions;
    private final PropertyIndexer properties;
    private final PrimitivePromoter promoter;
    private final ImportScanner scanner;
    private final ModuleRegistry registry;
    private final TypeIndexer indexer;

    public ClassIndexer(TypeIndexer indexer, ModuleRegistry registry, ImportScanner scanner, ClassExtender extender) {
        this.hierarchy = new ClassHierarchyIndexer(indexer);
        this.properties = new PropertyIndexer(indexer);
        this.functions = new FunctionIndexer(indexer, extender);
        this.extractor = new AnnotationExtractor();
        this.promoter = new PrimitivePromoter();
        this.scanner = scanner;
        this.registry = registry;
        this.indexer = indexer;
    }

    public List<Type> indexTypes(ClassType type) throws Exception {
        Class source = type.getType();
        Class actual = this.promoter.promote(source);
        if (actual == null) {
            throw new InternalArgumentException("Could not determine type for " + source);
        }
        return this.hierarchy.index(actual);
    }

    public List<Annotation> indexAnnotations(ClassType type) throws Exception {
        Class source = type.getType();
        Class actual = this.promoter.promote(source);
        if (actual == null) {
            throw new InternalArgumentException("Could not determine type for " + source);
        }
        return this.extractor.extract(actual);
    }

    public List<Property> indexProperties(ClassType type) throws Exception {
        Class source = type.getType();
        Class actual = this.promoter.promote(source);
        if (actual == null) {
            throw new InternalArgumentException("Could not determine type for " + source);
        }
        return this.properties.index(actual);
    }

    public List<Function> indexFunctions(ClassType type) throws Exception {
        Class source = type.getType();
        Class actual = this.promoter.promote(source);
        if (actual == null) {
            throw new InternalArgumentException("Could not determine type for " + source);
        }
        return this.functions.index(type);
    }

    public Module indexModule(ClassType type) throws Exception {
        String name;
        Class source = type.getType();
        Class<?> actual = this.promoter.promote(source);
        if (actual == null) {
            throw new InternalArgumentException("Could not determine type for " + source);
        }
        while (actual.isArray()) {
            actual = actual.getComponentType();
        }
        Package module = actual.getPackage();
        if (module != null && (name = this.scanner.importName(module)) != null) {
            return this.registry.addModule(name);
        }
        return this.registry.addModule("default");
    }

    public Type indexOuter(ClassType type) throws Exception {
        Class source = type.getType();
        Class<?> outer = source.getEnclosingClass();
        if (outer != null) {
            Class actual = this.promoter.promote(outer);
            if (actual == null) {
                throw new InternalArgumentException("Could not determine type for " + source);
            }
            return this.indexer.loadType(actual);
        }
        return null;
    }

    public Type indexEntry(ClassType type) throws Exception {
        Class source = type.getType();
        Class<?> entry = source.getComponentType();
        if (entry != null) {
            Class actual = this.promoter.promote(entry);
            if (actual == null) {
                throw new InternalArgumentException("Could not determine type for " + source);
            }
            return this.indexer.loadType(actual);
        }
        return null;
    }
}

