/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.index;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Type;
import org.snapscript.core.index.TypeIndexer;
import org.snapscript.core.property.ClassProperty;
import org.snapscript.core.property.Property;
import org.snapscript.core.property.ThisProperty;

public class ClassPropertyBuilder {
    private final TypeIndexer indexer;

    public ClassPropertyBuilder(TypeIndexer indexer) {
        this.indexer = indexer;
    }

    public List<Property> create(Class source) throws Exception {
        Type type = this.indexer.loadType(source);
        Type constraint = this.indexer.loadType(Type.class);
        if (type == null) {
            throw new InternalStateException("Could not load type for " + source);
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        ThisProperty thisProperty = new ThisProperty(type);
        ClassProperty classProperty = new ClassProperty(type, constraint);
        properties.add(thisProperty);
        properties.add(classProperty);
        return properties;
    }
}

