/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.index;

import java.lang.reflect.Constructor;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Type;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.InvocationFunction;
import org.snapscript.core.function.Signature;
import org.snapscript.core.index.ConstructorInvocation;
import org.snapscript.core.index.SignatureGenerator;
import org.snapscript.core.index.TypeIndexer;

public class ConstructorGenerator {
    private final SignatureGenerator generator;

    public ConstructorGenerator(TypeIndexer indexer) {
        this.generator = new SignatureGenerator(indexer);
    }

    public Function generate(Type type, Constructor constructor, Class[] types, int modifiers) {
        Signature signature = this.generator.generate(type, constructor);
        try {
            ConstructorInvocation invocation = new ConstructorInvocation(constructor);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new InvocationFunction(signature, invocation, type, type, "new", modifiers);
        }
        catch (Exception e) {
            throw new InternalStateException("Could not create function for " + constructor, e);
        }
    }
}

