/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.index;

import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.function.Accessor;

public class FinalFieldAccessor
implements Accessor<Object> {
    private final AtomicReference<Object> reference = new AtomicReference();
    private final Field field;

    public FinalFieldAccessor(Field field) {
        this.field = field;
    }

    @Override
    public Object getValue(Object source) {
        try {
            Object value = this.reference.get();
            if (value == null) {
                value = this.field.get(source);
                this.reference.set(value);
            }
            return value;
        }
        catch (Exception e) {
            throw new InternalStateException("Illegal access to " + this.field, e);
        }
    }

    @Override
    public void setValue(Object source, Object value) {
        throw new InternalStateException("Illegal modification of final " + this.field);
    }
}

