/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.index;

import java.lang.reflect.Method;
import org.snapscript.core.Any;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Type;
import org.snapscript.core.function.Function;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.InvocationFunction;
import org.snapscript.core.function.Signature;
import org.snapscript.core.index.DefaultMethodChecker;
import org.snapscript.core.index.DefaultMethodInvocation;
import org.snapscript.core.index.MethodInvocation;
import org.snapscript.core.index.SignatureGenerator;
import org.snapscript.core.index.TypeIndexer;

public class FunctionGenerator {
    private final SignatureGenerator generator;
    private final DefaultMethodChecker checker;
    private final TypeIndexer indexer;

    public FunctionGenerator(TypeIndexer indexer) {
        this.generator = new SignatureGenerator(indexer);
        this.checker = new DefaultMethodChecker();
        this.indexer = indexer;
    }

    public Function generate(Type type, Method method, Class[] types, String name, int modifiers) {
        Signature signature = this.generator.generate(type, method);
        Class<?> real = method.getReturnType();
        try {
            Invocation<Object> invocation = null;
            invocation = this.checker.check(method) ? new DefaultMethodInvocation(method) : new MethodInvocation(method);
            Type returns = this.indexer.loadType(real);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (real != Void.TYPE && real != Any.class && real != Object.class) {
                return new InvocationFunction(signature, invocation, type, returns, name, modifiers);
            }
            return new InvocationFunction(signature, invocation, type, null, name, modifiers);
        }
        catch (Exception e) {
            throw new InternalStateException("Could not create function for " + method, e);
        }
    }
}

