/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.index;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.Type;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.annotation.AnnotationExtractor;
import org.snapscript.core.extend.ClassExtender;
import org.snapscript.core.function.Function;
import org.snapscript.core.index.ConstructorIndexer;
import org.snapscript.core.index.FunctionGenerator;
import org.snapscript.core.index.ModifierConverter;
import org.snapscript.core.index.TypeIndexer;

public class FunctionIndexer {
    private final AnnotationExtractor extractor;
    private final FunctionGenerator generator;
    private final ConstructorIndexer indexer;
    private final ModifierConverter converter;
    private final ClassExtender extender;

    public FunctionIndexer(TypeIndexer indexer, ClassExtender extender) {
        this.generator = new FunctionGenerator(indexer);
        this.indexer = new ConstructorIndexer(indexer);
        this.extractor = new AnnotationExtractor();
        this.converter = new ModifierConverter();
        this.extender = extender;
    }

    public List<Function> index(Type type) throws Exception {
        Class source = type.getType();
        List<Function> extensions = this.extender.extend(source);
        List<Function> constructors = this.indexer.index(type);
        Method[] methods = source.getDeclaredMethods();
        for (Function extension : extensions) {
            constructors.add(extension);
        }
        if (methods.length > 0) {
            ArrayList<Function> functions = new ArrayList<Function>();
            for (Method method : methods) {
                int modifiers = this.converter.convert(method);
                if (!ModifierType.isPublic(modifiers) && !ModifierType.isProtected(modifiers)) continue;
                String name = method.getName();
                Class[] parameters = method.getParameterTypes();
                Function function = this.generator.generate(type, method, parameters, name, modifiers);
                List<Annotation> extracted = this.extractor.extract(method);
                List<Annotation> actual = function.getAnnotations();
                functions.add(function);
                actual.addAll(extracted);
            }
            if (!constructors.isEmpty()) {
                functions.addAll(constructors);
            }
            return functions;
        }
        return constructors;
    }
}

