/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.index;

import java.lang.reflect.Method;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Type;
import org.snapscript.core.function.Accessor;

public class MethodAccessor
implements Accessor<Object> {
    private final ParameterConverter converter;
    private final Method write;
    private final Method read;

    public MethodAccessor(Type type, Method read) {
        this(type, read, null);
    }

    public MethodAccessor(Type type, Method read, Method write) {
        this.converter = new ParameterConverter(type);
        this.write = write;
        this.read = read;
    }

    @Override
    public Object getValue(Object source) {
        try {
            return this.read.invoke(source, new Object[0]);
        }
        catch (Exception e) {
            throw new InternalStateException("Illegal access to " + this.read, e);
        }
    }

    @Override
    public void setValue(Object source, Object value) {
        try {
            if (this.write == null) {
                throw new InternalStateException("Illegal write for " + this.read);
            }
            if (value != null) {
                value = this.converter.convert(value);
            }
            this.write.invoke(source, value);
        }
        catch (Exception e) {
            throw new InternalStateException("Illegal access to " + this.write, e);
        }
    }

    private static class ParameterConverter {
        private final Type type;

        public ParameterConverter(Type type) {
            this.type = type;
        }

        public Object convert(Object value) {
            Class<?> actual = value.getClass();
            Class<?> parent = actual.getSuperclass();
            Class require = this.type.getType();
            if (require == String.class) {
                return String.valueOf(value);
            }
            if (parent == Number.class) {
                Number number = (Number)value;
                if (require == Double.class) {
                    return number.doubleValue();
                }
                if (require == Integer.class) {
                    return number.intValue();
                }
                if (require == Float.class) {
                    return Float.valueOf(number.floatValue());
                }
                if (require == Long.class) {
                    return number.longValue();
                }
                if (require == Short.class) {
                    return number.shortValue();
                }
                if (require == Byte.class) {
                    return number.byteValue();
                }
            }
            return value;
        }
    }
}

