/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.index;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.PrimitivePromoter;
import org.snapscript.core.Type;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.annotation.AnnotationExtractor;
import org.snapscript.core.index.ClassPropertyBuilder;
import org.snapscript.core.index.MethodMatcher;
import org.snapscript.core.index.ModifierConverter;
import org.snapscript.core.index.PropertyGenerator;
import org.snapscript.core.index.PropertyNameExtractor;
import org.snapscript.core.index.TypeIndexer;
import org.snapscript.core.property.Property;

public class PropertyIndexer {
    private final AnnotationExtractor extractor;
    private final ClassPropertyBuilder builder;
    private final ModifierConverter converter;
    private final PropertyGenerator generator;
    private final PrimitivePromoter promoter;
    private final MethodMatcher matcher;
    private final TypeIndexer indexer;

    public PropertyIndexer(TypeIndexer indexer) {
        this.builder = new ClassPropertyBuilder(indexer);
        this.extractor = new AnnotationExtractor();
        this.converter = new ModifierConverter();
        this.generator = new PropertyGenerator();
        this.promoter = new PrimitivePromoter();
        this.matcher = new MethodMatcher();
        this.indexer = indexer;
    }

    public List<Property> index(Class source) throws Exception {
        List<Property> properties = this.builder.create(source);
        Method[] methods = source.getDeclaredMethods();
        Field[] fields = source.getDeclaredFields();
        Type type = this.indexer.loadType(source);
        if (fields.length > 0 || methods.length > 0) {
            int modifiers;
            HashSet<String> done = new HashSet<String>();
            for (Field field : fields) {
                modifiers = this.converter.convert(field);
                if (!ModifierType.isPublic(modifiers) && !ModifierType.isProtected(modifiers)) continue;
                String name = field.getName();
                Class<?> declaration = field.getType();
                Type constraint = this.indexer.loadType(declaration);
                Property property = this.generator.generate(field, type, constraint, name, modifiers);
                List<Annotation> extracted = this.extractor.extract(field);
                List<Annotation> actual = property.getAnnotations();
                done.add(name);
                properties.add(property);
                actual.addAll(extracted);
            }
            for (AccessibleObject accessibleObject : methods) {
                String name;
                modifiers = this.converter.convert((Method)accessibleObject);
                if (!ModifierType.isPublic(modifiers) || ModifierType.isStatic(modifiers)) continue;
                Class<?>[] parameters = ((Method)accessibleObject).getParameterTypes();
                Class<?> returns = ((Method)accessibleObject).getReturnType();
                if (parameters.length != 0 || returns == Void.TYPE || !done.add(name = PropertyNameExtractor.getProperty((Method)accessibleObject))) continue;
                Class<?> declaration = ((Method)accessibleObject).getReturnType();
                Method write = this.matcher.match(methods, declaration, name);
                if (write == null) {
                    modifiers |= ModifierType.CONSTANT.mask;
                }
                Class normal = this.promoter.promote(declaration);
                Type constraint = this.indexer.loadType(normal);
                Property property = this.generator.generate((Method)accessibleObject, write, type, constraint, name, modifiers);
                List<Annotation> extracted = this.extractor.extract(accessibleObject);
                List<Annotation> actual = property.getAnnotations();
                if (write != null) {
                    write.setAccessible(true);
                }
                ((Method)accessibleObject).setAccessible(true);
                properties.add(property);
                actual.addAll(extracted);
            }
        }
        return properties;
    }
}

