/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.index;

import java.lang.reflect.Method;
import org.snapscript.core.function.Function;

public class PropertyNameExtractor {
    private static final String[] PREFIXES = new String[]{"get", "set", "is"};

    public static String getProperty(Method method) {
        String name = method.getName();
        for (String prefix : PREFIXES) {
            String property = PropertyNameExtractor.getProperty(name, prefix);
            if (property == null) continue;
            return property;
        }
        return name;
    }

    public static String getProperty(Function function) {
        String name = function.getName();
        for (String prefix : PREFIXES) {
            String property = PropertyNameExtractor.getProperty(name, prefix);
            if (property == null) continue;
            return property;
        }
        return name;
    }

    public static String getProperty(String function, String prefix) {
        int require;
        int actual = function.length();
        if (actual > (require = prefix.length()) && function.startsWith(prefix)) {
            String token = function.substring(require);
            return PropertyNameExtractor.getProperty(token);
        }
        return function;
    }

    private static String getProperty(String name) {
        int length = name.length();
        if (length > 0) {
            char[] array = name.toCharArray();
            char first = array[0];
            if (!PropertyNameExtractor.isAcronym(array)) {
                array[0] = PropertyNameExtractor.toLowerCase(first);
            }
            return new String(array);
        }
        return name;
    }

    private static boolean isAcronym(char[] array) {
        if (array.length < 2) {
            return false;
        }
        if (!PropertyNameExtractor.isUpperCase(array[0])) {
            return false;
        }
        return PropertyNameExtractor.isUpperCase(array[1]);
    }

    private static char toLowerCase(char value) {
        return Character.toLowerCase(value);
    }

    private static boolean isUpperCase(char value) {
        return Character.isUpperCase(value);
    }
}

