/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.index;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.ModuleRegistry;
import org.snapscript.core.NameBuilder;
import org.snapscript.core.Type;
import org.snapscript.core.TypeNameBuilder;
import org.snapscript.core.extend.ClassExtender;
import org.snapscript.core.index.ClassIndexer;
import org.snapscript.core.index.ClassType;
import org.snapscript.core.index.ScopeArrayType;
import org.snapscript.core.index.ScopeType;
import org.snapscript.core.link.ImportScanner;

public class TypeIndexer {
    private final Map<Object, Type> types;
    private final ModuleRegistry registry;
    private final ImportScanner scanner;
    private final ClassIndexer indexer;
    private final AtomicInteger counter;
    private final NameBuilder builder;
    private final int limit;

    public TypeIndexer(ModuleRegistry registry, ImportScanner scanner, ClassExtender extender) {
        this(registry, scanner, extender, 100000);
    }

    public TypeIndexer(ModuleRegistry registry, ImportScanner scanner, ClassExtender extender, int limit) {
        this.indexer = new ClassIndexer(this, registry, scanner, extender);
        this.types = new LinkedHashMap<Object, Type>();
        this.builder = new TypeNameBuilder();
        this.counter = new AtomicInteger(1);
        this.registry = registry;
        this.scanner = scanner;
        this.limit = limit;
    }

    public synchronized Type loadType(String type) {
        Type done = this.types.get(type);
        if (done == null) {
            Class match = this.scanner.importType(type);
            if (match == null) {
                return null;
            }
            return this.loadType(match);
        }
        return done;
    }

    public synchronized Type loadType(String module, String name) {
        String alias = this.builder.createFullName(module, name);
        Type done = this.types.get(alias);
        if (done == null) {
            Class match = this.scanner.importType(alias);
            if (match == null) {
                return null;
            }
            return this.loadType(match);
        }
        return done;
    }

    public synchronized Type loadType(String module, String name, int size) {
        String alias = this.builder.createArrayName(module, name, size);
        Type done = this.types.get(alias);
        if (done == null) {
            String type = this.builder.createFullName(module, name);
            Class match = this.scanner.importType(type, size);
            if (match == null) {
                if (size > 0) {
                    return this.createType(module, name, size);
                }
                return this.defineType(module, name);
            }
            return this.loadType(match);
        }
        return done;
    }

    public synchronized Type defineType(String module, String name) {
        String alias = this.builder.createFullName(module, name);
        Type done = this.types.get(alias);
        if (done == null) {
            Class match = this.scanner.importType(alias);
            if (match == null) {
                Type type = this.createType(module, name);
                this.types.put(type, type);
                this.types.put(alias, type);
                return type;
            }
            return this.loadType(match);
        }
        return done;
    }

    public synchronized Type loadType(Class source) {
        Type done = this.types.get(source);
        if (done == null) {
            String alias = this.scanner.importName(source);
            String absolute = source.getName();
            Type type = this.createType(source);
            this.types.put(source, type);
            this.types.put(alias, type);
            this.types.put(absolute, type);
            return type;
        }
        return done;
    }

    private synchronized Type createType(String module, String name) {
        String alias = this.builder.createFullName(module, name);
        String prefix = this.builder.createOuterName(module, name);
        Module parent = this.registry.addModule(module);
        Type type = this.types.get(alias);
        if (type == null) {
            Type outer = this.types.get(prefix);
            int order = this.counter.getAndIncrement();
            if (order > this.limit) {
                throw new InternalStateException("Type limit of " + this.limit + " exceeded");
            }
            return new ScopeType(parent, outer, name, order);
        }
        return type;
    }

    private synchronized Type createType(String module, String name, int size) {
        String alias = this.builder.createArrayName(module, name, size);
        Module parent = this.registry.addModule(module);
        Type type = this.types.get(alias);
        if (type == null) {
            Type entry = this.loadType(module, name, size - 1);
            if (entry == null) {
                throw new InternalStateException("Type entry for '" + alias + "' not found");
            }
            String array = this.builder.createArrayName(null, name, size);
            int order = this.counter.getAndIncrement();
            if (order > this.limit) {
                throw new InternalStateException("Type limit of " + this.limit + " exceeded");
            }
            return new ScopeArrayType(parent, array, entry, size, order);
        }
        return type;
    }

    private synchronized Type createType(Class source) {
        String alias = this.scanner.importName(source);
        Type type = this.types.get(alias);
        if (type == null) {
            String name = this.builder.createShortName(source);
            int order = this.counter.getAndIncrement();
            if (order > this.limit) {
                throw new InternalStateException("Type limit of " + this.limit + " exceeded");
            }
            return new ClassType(this.indexer, source, name, order);
        }
        return type;
    }
}

