/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.Any;
import org.snapscript.core.ContextClassLoader;

public class ImportLoader {
    private final Cache<String, Package> packages = new CopyOnWriteCache<String, Package>();
    private final Cache<String, Class> types = new CopyOnWriteCache<String, Class>();
    private final ClassLoader loader = new ContextClassLoader(Any.class);

    public Package loadPackage(String name) {
        try {
            if (!this.packages.contains(name)) {
                Package match = Package.getPackage(name);
                this.packages.cache(name, match);
            }
        }
        catch (Exception e) {
            this.packages.cache(name, null);
            return null;
        }
        return this.packages.fetch(name);
    }

    public Class loadClass(String name) {
        try {
            if (!this.types.contains(name)) {
                Class<?> match = this.loader.loadClass(name);
                this.types.cache(name, match);
            }
        }
        catch (Exception e) {
            this.types.cache(name, null);
            return null;
        }
        return this.types.fetch(name);
    }
}

