/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.snapscript.core.Context;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Module;
import org.snapscript.core.ModuleRegistry;
import org.snapscript.core.Path;
import org.snapscript.core.Type;
import org.snapscript.core.TypeLoader;
import org.snapscript.core.link.ImportMatcher;

public class ImportManager {
    private final Map<String, String> aliases = new ConcurrentHashMap<String, String>();
    private final Set<String> imports = new CopyOnWriteArraySet<String>();
    private final ImportMatcher matcher;
    private final Module parent;
    private final String from;

    public ImportManager(Module parent, Path path, String from) {
        this.matcher = new ImportMatcher(parent, path, from);
        this.parent = parent;
        this.from = from;
    }

    public void addImport(String prefix) {
        this.imports.add(prefix);
    }

    public void addImport(String type, String alias) {
        this.aliases.put(alias, type);
    }

    public void addImports(Module module) {
        ImportManager manager = module.getManager();
        if (manager != null) {
            manager.aliases.putAll(this.aliases);
            manager.imports.addAll(this.imports);
        }
    }

    public Module getModule(String name) {
        try {
            String alias;
            Context context = this.parent.getContext();
            ModuleRegistry registry = context.getRegistry();
            Module module = registry.getModule(name);
            if (module == null && (alias = this.aliases.get(name)) != null) {
                module = registry.getModule(alias);
            }
            Type type = this.getType(name);
            if (module == null && type == null) {
                module = this.matcher.importModule(this.imports, name);
            }
            return module;
        }
        catch (Exception e) {
            throw new InternalStateException("Could not find '" + name + "' in '" + this.from + "'", e);
        }
    }

    public Type getType(String name) {
        try {
            Context context = this.parent.getContext();
            TypeLoader loader = context.getLoader();
            Type type = loader.resolveType(this.from, name);
            if (type == null) {
                String alias = this.aliases.get(name);
                if (alias != null && (type = loader.resolveType(alias)) != null) {
                    return type;
                }
                for (String module : this.imports) {
                    type = loader.resolveType(module, name);
                    if (type == null) continue;
                    return type;
                }
                if (type == null) {
                    type = loader.resolveType(null, name);
                }
                if (type == null) {
                    type = this.matcher.importType(this.imports, name);
                }
            }
            return type;
        }
        catch (Exception e) {
            throw new InternalStateException("Could not find '" + name + "' in '" + this.from + "'", e);
        }
    }
}

