/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.Set;
import java.util.concurrent.Callable;
import org.snapscript.core.Context;
import org.snapscript.core.Module;
import org.snapscript.core.ModuleRegistry;
import org.snapscript.core.NameBuilder;
import org.snapscript.core.Path;
import org.snapscript.core.Type;
import org.snapscript.core.TypeNameBuilder;
import org.snapscript.core.link.ImportTaskResolver;

public class ImportMatcher {
    private final ImportTaskResolver resolver;
    private final NameBuilder builder;
    private final Module parent;
    private final String from;

    public ImportMatcher(Module parent, Path path, String from) {
        this.resolver = new ImportTaskResolver(parent, path);
        this.builder = new TypeNameBuilder();
        this.parent = parent;
        this.from = from;
    }

    public Type importType(Set<String> prefixes, String name) throws Exception {
        Context context = this.parent.getContext();
        ModuleRegistry registry = context.getRegistry();
        for (String prefix : prefixes) {
            Type type;
            Module match = registry.getModule(prefix);
            if (match == this.parent || match == null || (type = match.getType(name)) == null) continue;
            return type;
        }
        for (String prefix : prefixes) {
            Type type = this.importType(prefix, name);
            if (type == null) continue;
            return type;
        }
        String type = this.builder.createFullName(this.from, name);
        Module module = registry.getModule(type);
        if (module == null) {
            return this.importType(this.from, name);
        }
        return null;
    }

    private Type importType(String prefix, String name) throws Exception {
        String type = this.builder.createFullName(prefix, name);
        Callable<Type> task = this.resolver.importType(type);
        if (task != null) {
            return task.call();
        }
        return null;
    }

    public Module importModule(Set<String> prefixes, String name) throws Exception {
        Context context = this.parent.getContext();
        ModuleRegistry registry = context.getRegistry();
        for (String prefix : prefixes) {
            String inner = this.builder.createFullName(prefix, name);
            Module match = registry.getModule(inner);
            if (match == null) continue;
            return match;
        }
        for (String prefix : prefixes) {
            Module module = this.importModule(prefix, name);
            if (module == null) continue;
            return module;
        }
        return this.importModule(this.from, name);
    }

    private Module importModule(String prefix, String name) throws Exception {
        String type = this.builder.createFullName(prefix, name);
        Callable<Module> task = this.resolver.importModule(type);
        if (task != null) {
            return task.call();
        }
        return null;
    }
}

