/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.lang.reflect.Array;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.snapscript.common.Cache;
import org.snapscript.common.CopyOnWriteCache;
import org.snapscript.core.NameBuilder;
import org.snapscript.core.TypeNameBuilder;
import org.snapscript.core.link.ImportLoader;

public class ImportScanner {
    private static final String[] DEFAULTS = new String[]{"java.", "javax.", "java.lang.", "java.util.", "java.io.", "java.net.", "java.math.", "org.snapscript."};
    private final Cache<String, Package> packages = new CopyOnWriteCache<String, Package>();
    private final Cache<String, Class> types;
    private final Cache<Object, String> names = new CopyOnWriteCache<Object, String>();
    private final ImportLoader loader;
    private final NameBuilder builder;
    private final Set<String> failures;
    private final String[] prefixes;

    public ImportScanner() {
        this(DEFAULTS);
    }

    public ImportScanner(String ... prefixes) {
        this.types = new CopyOnWriteCache<String, Class>();
        this.failures = new CopyOnWriteArraySet<String>();
        this.builder = new TypeNameBuilder();
        this.loader = new ImportLoader();
        this.prefixes = prefixes;
    }

    public Package importPackage(String name) {
        if (!this.failures.contains(name)) {
            Package result = this.packages.fetch(name);
            if (result == null) {
                result = this.loadPackage(name);
            }
            if (result == null) {
                for (String prefix : this.prefixes) {
                    result = this.loadPackage(prefix + name);
                    if (result == null) continue;
                    this.packages.cache(name, result);
                    return result;
                }
                this.failures.add(name);
            }
            return result;
        }
        return null;
    }

    public Class importType(String name) {
        if (!this.failures.contains(name)) {
            Class type = this.types.fetch(name);
            if (type == null) {
                type = this.loadType(name);
            }
            if (type == null) {
                for (String prefix : this.prefixes) {
                    type = this.loadType(prefix + name);
                    if (type == null) continue;
                    this.types.cache(name, type);
                    return type;
                }
                this.failures.add(name);
            }
            return type;
        }
        return null;
    }

    public Class importType(String name, int size) {
        Class type = this.importType(name);
        if (type != null && size < 4) {
            Object array = null;
            if (size > 0) {
                if (size == 1) {
                    array = Array.newInstance(type, 0);
                } else if (size == 2) {
                    array = Array.newInstance(type, 0, 0);
                } else if (size == 3) {
                    array = Array.newInstance(type, 0, 0, 0);
                }
                return array.getClass();
            }
            return type;
        }
        return null;
    }

    public String importName(Class type) {
        String result = this.names.fetch(type);
        if (result == null) {
            String absolute = this.builder.createFullName(type);
            for (String prefix : this.prefixes) {
                if (absolute.startsWith(prefix)) {
                    int length = prefix.length();
                    String name = absolute.substring(length);
                    this.types.cache(absolute, type);
                    this.types.cache(name, type);
                    this.names.cache(type, name);
                    return name;
                }
                this.types.cache(absolute, type);
                this.names.cache(type, absolute);
            }
            return absolute;
        }
        return result;
    }

    public String importName(Package module) {
        String result = this.names.fetch(module);
        if (result == null) {
            String absolute = module.getName();
            for (String prefix : this.prefixes) {
                if (absolute.startsWith(prefix)) {
                    int length = prefix.length();
                    String name = absolute.substring(length);
                    this.packages.cache(absolute, module);
                    this.packages.cache(name, module);
                    this.names.cache(module, name);
                    return name;
                }
                this.packages.cache(absolute, module);
                this.names.cache(module, absolute);
            }
            return absolute;
        }
        return result;
    }

    private Class loadType(String name) {
        try {
            Class result = this.loader.loadClass(name);
            if (result != null) {
                this.types.cache(name, result);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Package loadPackage(String name) {
        try {
            Package result = this.loader.loadPackage(name);
            if (result != null) {
                this.packages.cache(name, result);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

