/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.link;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.FutureTask;
import org.snapscript.core.InternalStateException;
import org.snapscript.core.Path;
import org.snapscript.core.PathConverter;
import org.snapscript.core.ResourceManager;
import org.snapscript.core.link.ExceptionPackage;
import org.snapscript.core.link.FuturePackage;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageBundle;
import org.snapscript.core.link.PackageLinker;

public class PackageBundleLoader {
    private final ConcurrentMap<Path, Package> registry = new ConcurrentHashMap<Path, Package>();
    private final PathConverter converter;
    private final ResourceManager manager;
    private final PackageLinker linker;

    public PackageBundleLoader(PackageLinker linker, ResourceManager manager, PathConverter converter) {
        this.converter = converter;
        this.manager = manager;
        this.linker = linker;
    }

    public PackageBundle load(String ... resources) throws Exception {
        ArrayList<Package> packages = new ArrayList<Package>();
        PackageBundle bundle = new PackageBundle(packages);
        for (String resource : resources) {
            Path path = this.converter.createPath(resource);
            try {
                Package module = this.load(path);
                if (module == null) continue;
                packages.add(module);
            }
            catch (Exception e) {
                throw new InternalStateException("Error linking '" + path + "'", e);
            }
        }
        return bundle;
    }

    private Package load(Path path) throws Exception {
        String location;
        String source;
        Package module = (Package)this.registry.get(path);
        if (module == null && (source = this.manager.getString(location = path.getPath())) != null) {
            Executable executable = new Executable(path, source);
            FutureTask<Package> task = new FutureTask<Package>(executable);
            FuturePackage result = new FuturePackage(task, path);
            if (this.registry.putIfAbsent(path, result) == null) {
                task.run();
            }
            return (Package)this.registry.get(path);
        }
        return module;
    }

    private class Executable
    implements Callable<Package> {
        private final String source;
        private final Path path;

        public Executable(Path path, String source) {
            this.source = source;
            this.path = path;
        }

        @Override
        public Package call() throws Exception {
            try {
                Package result = PackageBundleLoader.this.linker.link(this.path, this.source);
                if (result != null) {
                    PackageBundleLoader.this.registry.put(this.path, result);
                }
                return result;
            }
            catch (Exception cause) {
                return new ExceptionPackage("Could not load library '" + this.path + "'", cause);
            }
        }
    }
}

