/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.stack;

import java.util.ArrayList;
import java.util.List;

public class OriginTraceExtractor {
    public static final int DEFAULT_DEPTH = 0;
    public static final int DEBUG_DEPTH = 2;
    private final int depth;

    public OriginTraceExtractor() {
        this(0);
    }

    public OriginTraceExtractor(int depth) {
        this.depth = depth;
    }

    public List<StackTraceElement> extract(Throwable cause) {
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        if (cause != null) {
            StackTraceElement[] elements = cause.getStackTrace();
            for (int i = 0; i < this.depth; ++i) {
                StackTraceElement element = elements[i];
                String source = element.getClassName();
                if (source.startsWith("org.snapscript.")) {
                    list.add(element);
                    continue;
                }
                if (source.startsWith("java.")) {
                    list.add(element);
                    continue;
                }
                return list;
            }
        }
        return list;
    }
}

