/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.stack;

import org.snapscript.core.Module;
import org.snapscript.core.Path;
import org.snapscript.core.Type;
import org.snapscript.core.TypeNameBuilder;
import org.snapscript.core.function.Function;
import org.snapscript.core.trace.Trace;

public class StackElement {
    private static final String MAIN_FUNCTION = "main";
    private final TypeNameBuilder builder = new TypeNameBuilder();
    private final Function function;
    private final Trace trace;

    public StackElement(Trace trace) {
        this(trace, null);
    }

    public StackElement(Trace trace, Function function) {
        this.function = function;
        this.trace = trace;
    }

    public StackTraceElement build() {
        Module module = this.trace.getModule();
        String name = module.getName();
        Path path = this.trace.getPath();
        int line = this.trace.getLine();
        return this.create(name, path, line);
    }

    private StackTraceElement create(String module, Path path, int line) {
        String resource = path.getPath();
        if (this.function != null) {
            String name = this.function.getName();
            Type type = this.function.getType();
            if (type != null) {
                Module parent = type.getModule();
                String prefix = parent.getName();
                String suffix = type.getName();
                String qualifier = this.builder.createFullName(prefix, suffix);
                return new StackTraceElement(qualifier, name, resource, line);
            }
            return new StackTraceElement(module, name, resource, line);
        }
        return new StackTraceElement(module, MAIN_FUNCTION, resource, line);
    }
}

