/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.stack;

import org.snapscript.common.Stack;
import org.snapscript.core.function.Function;
import org.snapscript.core.stack.StackTraceBuilder;
import org.snapscript.core.stack.ThreadLocalStack;

public class ThreadStack {
    private final StackTraceBuilder builder = new StackTraceBuilder();
    private final ThreadLocalStack local = new ThreadLocalStack();

    public Function current() {
        Stack stack = (Stack)this.local.get();
        for (Object entry : stack) {
            if (!Function.class.isInstance(entry)) continue;
            return (Function)entry;
        }
        return null;
    }

    public StackTraceElement[] build() {
        return this.build(null);
    }

    public StackTraceElement[] build(Throwable cause) {
        Stack stack = (Stack)this.local.get();
        if (cause != null) {
            return this.builder.create(stack, cause);
        }
        return this.builder.create(stack);
    }

    public void before(Object trace) {
        Stack stack = (Stack)this.local.get();
        if (trace != null) {
            stack.push(trace);
        }
    }

    public void after(Object trace) {
        Object next;
        Stack stack = (Stack)this.local.get();
        while (!stack.isEmpty() && (next = stack.pop()) != trace) {
        }
    }

    public void clear() {
        Stack stack = (Stack)this.local.get();
        stack.clear();
    }
}

