/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.trace;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.snapscript.core.Scope;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceListener;

public class TraceInterceptor
implements TraceListener {
    private final Set<TraceListener> listeners = new CopyOnWriteArraySet<TraceListener>();
    private final ThreadStack stack;

    public TraceInterceptor(ThreadStack stack) {
        this.stack = stack;
    }

    @Override
    public void before(Scope scope, Trace trace) {
        this.stack.before(trace);
        if (!this.listeners.isEmpty()) {
            for (TraceListener listener : this.listeners) {
                listener.before(scope, trace);
            }
        }
    }

    @Override
    public void error(Scope scope, Trace trace, Exception cause) {
        if (!this.listeners.isEmpty()) {
            for (TraceListener listener : this.listeners) {
                listener.error(scope, trace, cause);
            }
        }
    }

    @Override
    public void after(Scope scope, Trace trace) {
        this.stack.after(trace);
        if (!this.listeners.isEmpty()) {
            for (TraceListener listener : this.listeners) {
                listener.after(scope, trace);
            }
        }
    }

    public void register(TraceListener listener) {
        this.listeners.add(listener);
    }

    public void remove(TraceListener listener) {
        this.listeners.remove(listener);
    }
}

