/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.core.trace;

import org.snapscript.core.Result;
import org.snapscript.core.Scope;
import org.snapscript.core.Statement;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;

public class TraceStatement
extends Statement {
    private final TraceInterceptor interceptor;
    private final ErrorHandler handler;
    private final Statement statement;
    private final Trace trace;

    public TraceStatement(TraceInterceptor interceptor, ErrorHandler handler, Statement statement, Trace trace) {
        this.interceptor = interceptor;
        this.statement = statement;
        this.handler = handler;
        this.trace = trace;
    }

    @Override
    public Result compile(Scope scope) throws Exception {
        return this.statement.compile(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Scope scope) throws Exception {
        try {
            this.interceptor.before(scope, this.trace);
            Result result = this.statement.execute(scope);
            return result;
        }
        catch (Exception cause) {
            this.interceptor.error(scope, this.trace, cause);
            Result result = this.handler.throwInternal(scope, cause);
            return result;
        }
        finally {
            this.interceptor.after(scope, this.trace);
        }
    }
}

