/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.dx.dex.file;

import org.snapscript.dx.dex.file.AnnotationItem;
import org.snapscript.dx.dex.file.DexFile;
import org.snapscript.dx.dex.file.ItemType;
import org.snapscript.dx.dex.file.MixedItemSection;
import org.snapscript.dx.dex.file.OffsettedItem;
import org.snapscript.dx.dex.file.Section;
import org.snapscript.dx.rop.annotation.Annotation;
import org.snapscript.dx.rop.annotation.Annotations;
import org.snapscript.dx.util.AnnotatedOutput;
import org.snapscript.dx.util.Hex;

public final class AnnotationSetItem
extends OffsettedItem {
    private static final int ALIGNMENT = 4;
    private static final int ENTRY_WRITE_SIZE = 4;
    private final Annotations annotations;
    private final AnnotationItem[] items;

    public AnnotationSetItem(Annotations annotations) {
        super(4, AnnotationSetItem.writeSize(annotations));
        this.annotations = annotations;
        this.items = new AnnotationItem[annotations.size()];
        int at = 0;
        for (Annotation a : annotations.getAnnotations()) {
            this.items[at] = new AnnotationItem(a);
            ++at;
        }
    }

    private static int writeSize(Annotations annotations) {
        try {
            return annotations.size() * 4 + 4;
        }
        catch (NullPointerException ex) {
            throw new NullPointerException("list == null");
        }
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }

    public int hashCode() {
        return this.annotations.hashCode();
    }

    @Override
    protected int compareTo0(OffsettedItem other) {
        AnnotationSetItem otherSet = (AnnotationSetItem)other;
        return this.annotations.compareTo(otherSet.annotations);
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_ANNOTATION_SET_ITEM;
    }

    @Override
    public String toHuman() {
        return this.annotations.toString();
    }

    @Override
    public void addContents(DexFile file) {
        MixedItemSection byteData = file.getByteData();
        int size = this.items.length;
        for (int i = 0; i < size; ++i) {
            this.items[i] = byteData.intern(this.items[i]);
        }
    }

    @Override
    protected void place0(Section addedTo, int offset) {
        AnnotationItem.sortByTypeIdIndex(this.items);
    }

    @Override
    protected void writeTo0(DexFile file, AnnotatedOutput out) {
        boolean annotates = out.annotates();
        int size = this.items.length;
        if (annotates) {
            out.annotate(0, this.offsetString() + " annotation set");
            out.annotate(4, "  size: " + Hex.u4(size));
        }
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            AnnotationItem item = this.items[i];
            int offset = item.getAbsoluteOffset();
            if (annotates) {
                out.annotate(4, "  entries[" + Integer.toHexString(i) + "]: " + Hex.u4(offset));
                this.items[i].annotateTo(out, "    ");
            }
            out.writeInt(offset);
        }
    }
}

