/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import java.util.ArrayList;
import java.util.List;
import org.snapscript.parse.Grammar;
import org.snapscript.parse.GrammarIndexer;
import org.snapscript.parse.GrammarResolver;
import org.snapscript.parse.LiteralGrammar;
import org.snapscript.parse.MatchAllGrammar;
import org.snapscript.parse.MatchFirstGrammar;
import org.snapscript.parse.MatchOneGrammar;
import org.snapscript.parse.OptionalGrammar;
import org.snapscript.parse.ReferenceGrammar;
import org.snapscript.parse.RepeatGrammar;
import org.snapscript.parse.SpaceGrammar;
import org.snapscript.parse.Symbol;
import org.snapscript.parse.SymbolGrammar;

public class GrammarBuilder {
    private final GrammarResolver resolver;
    private final GrammarIndexer indexer;

    public GrammarBuilder(GrammarResolver resolver, GrammarIndexer indexer) {
        this.resolver = resolver;
        this.indexer = indexer;
    }

    public Grammar createSpace(String text, String origin) {
        return new SpaceGrammar();
    }

    public Grammar createLiteral(String text, String origin) {
        String value = this.indexer.literal(text);
        return new LiteralGrammar(value);
    }

    public Grammar createReference(String text, String origin) {
        int index = this.indexer.index(text);
        return new ReferenceGrammar(this.resolver, text, index);
    }

    public Grammar createOptional(Grammar node, String origin) {
        return new OptionalGrammar(node);
    }

    public Grammar createRepeat(Grammar node, String origin) {
        return new RepeatGrammar(node);
    }

    public Grammar createRepeatOnce(Grammar node, String origin) {
        return new RepeatGrammar(node, true);
    }

    public Grammar createSpecial(String text, String origin) {
        Symbol[] symbols;
        for (Symbol symbol : symbols = Symbol.values()) {
            if (!symbol.name.equals(text)) continue;
            int index = this.indexer.index(text);
            return new SymbolGrammar(symbol, text, index);
        }
        return null;
    }

    public Grammar createMatchBest(List<Grammar> nodes, String origin) {
        Grammar top = nodes.get(0);
        int count = nodes.size();
        int index = this.indexer.index(origin);
        if (count > 1) {
            ArrayList<Grammar> copy = new ArrayList<Grammar>(nodes);
            MatchOneGrammar choice = new MatchOneGrammar(copy, origin, index);
            return choice;
        }
        return top;
    }

    public Grammar createMatchFirst(List<Grammar> nodes, String origin) {
        Grammar top = nodes.get(0);
        int count = nodes.size();
        int index = this.indexer.index(origin);
        if (count > 1) {
            ArrayList<Grammar> copy = new ArrayList<Grammar>(nodes);
            MatchFirstGrammar choice = new MatchFirstGrammar(copy, origin, index);
            return choice;
        }
        return top;
    }

    public Grammar createMatchAll(List<Grammar> nodes, String origin) {
        Grammar top = nodes.get(0);
        int count = nodes.size();
        int index = this.indexer.index(origin);
        if (count > 1) {
            ArrayList<Grammar> copy = new ArrayList<Grammar>(nodes);
            MatchAllGrammar group = new MatchAllGrammar(copy, origin, index);
            return group;
        }
        return top;
    }
}

