/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.parse.Grammar;
import org.snapscript.parse.GrammarBuilder;
import org.snapscript.parse.GrammarIndexer;
import org.snapscript.parse.GrammarResolver;
import org.snapscript.parse.ParseException;
import org.snapscript.parse.Rule;
import org.snapscript.parse.RuleIterator;
import org.snapscript.parse.RuleParser;
import org.snapscript.parse.RuleType;

public class GrammarCompiler {
    private final GrammarBuilder builder;

    public GrammarCompiler(GrammarResolver resolver, GrammarIndexer indexer) {
        this.builder = new GrammarBuilder(resolver, indexer);
    }

    public Grammar process(String name, String syntax) {
        RuleParser iterator = new RuleParser(name, syntax);
        if (!iterator.hasNext()) {
            throw new ParseException("Grammar contains no rules");
        }
        Grammar result = this.sequence(iterator, RuleType.OPEN_GROUP);
        if (result == null) {
            throw new ParseException("Could not consume node for " + name);
        }
        return result;
    }

    private Grammar optional(RuleIterator iterator, RuleType previous) {
        Rule start = iterator.next();
        RuleType open = start.getType();
        if (!open.isOptional()) {
            throw new ParseException("Optional does not begin with " + (Object)((Object)open));
        }
        Rule rule = iterator.peek();
        RuleType type = rule.getType();
        String origin = rule.getOrigin();
        if (type.isToken()) {
            Grammar node = this.next(iterator, previous);
            iterator.next();
            return this.builder.createOptional(node, origin);
        }
        if (type.isOpenGroup() || type.isOpenChoice()) {
            Grammar node = this.consume(iterator, type);
            if (node == null) {
                throw new ParseException("Could not create optional with type " + (Object)((Object)type));
            }
            return this.builder.createOptional(node, origin);
        }
        throw new ParseException("Unable to create optional with " + (Object)((Object)type));
    }

    private Grammar repeat(RuleIterator iterator, RuleType previous) {
        Rule start = iterator.next();
        RuleType open = start.getType();
        if (!open.isRepeat() && !open.isRepeatOnce()) {
            throw new ParseException("Repeat does not begin with " + (Object)((Object)open));
        }
        Rule rule = iterator.peek();
        RuleType type = rule.getType();
        String origin = rule.getOrigin();
        if (type.isToken()) {
            Grammar node = this.next(iterator, previous);
            iterator.next();
            if (open.isRepeatOnce()) {
                return this.builder.createRepeatOnce(node, origin);
            }
            return this.builder.createRepeat(node, origin);
        }
        if (type.isOpenGroup() || type.isOpenChoice()) {
            Grammar node = this.consume(iterator, type);
            if (node == null) {
                throw new ParseException("Could not create repeat with type " + (Object)((Object)type));
            }
            if (open.isRepeatOnce()) {
                return this.builder.createRepeatOnce(node, origin);
            }
            return this.builder.createRepeat(node, origin);
        }
        throw new ParseException("Unable to create repeat with " + (Object)((Object)type));
    }

    private Grammar group(RuleIterator iterator, RuleType previous) {
        ArrayList<Grammar> nodes = new ArrayList<Grammar>();
        if (!iterator.hasNext()) {
            throw new ParseException("Rules have been exhausted");
        }
        Rule start = iterator.next();
        RuleType open = start.getType();
        if (!open.isOpenGroup() && !open.isOpenChoice()) {
            throw new ParseException("Group does not begin with " + (Object)((Object)open));
        }
        while (iterator.hasNext()) {
            Grammar result;
            Rule rule = iterator.peek();
            RuleType type = rule.getType();
            String origin = rule.getOrigin();
            if (type.isCloseGroup() || type.isCloseChoice()) {
                Grammar group = this.builder.createMatchAll(nodes, origin);
                iterator.next();
                return group;
            }
            if (type.isOpenGroup() || type.isOpenChoice()) {
                result = this.consume(iterator, type);
                if (result == null) {
                    throw new ParseException("Could not consume node of type " + (Object)((Object)type));
                }
                nodes.add(result);
                continue;
            }
            result = this.consume(iterator, previous);
            if (result == null) {
                throw new ParseException("Could not consume node of type " + (Object)((Object)type));
            }
            nodes.add(result);
        }
        throw new ParseException("Group did not terminate");
    }

    private Grammar sequence(RuleIterator iterator, RuleType previous) {
        AtomicReference<String> last = new AtomicReference<String>();
        ArrayList<Grammar> choices = new ArrayList<Grammar>();
        ArrayList<Grammar> sequence = new ArrayList<Grammar>();
        if (!iterator.hasNext()) {
            throw new ParseException("Rules have been exhausted");
        }
        while (iterator.hasNext()) {
            Grammar next;
            Rule rule = iterator.peek();
            RuleType type = rule.getType();
            String origin = rule.getOrigin();
            if (type.isSplitter()) {
                Grammar group = this.builder.createMatchAll(sequence, origin);
                sequence.clear();
                choices.add(group);
                iterator.next();
            } else if (type.isToken()) {
                next = this.next(iterator, previous);
                if (next != null) {
                    sequence.add(next);
                }
                iterator.next();
            } else {
                if (type.isCloseGroup() || type.isCloseChoice()) break;
                next = this.consume(iterator, type);
                if (next != null) {
                    sequence.add(next);
                }
                last.set(origin);
            }
            last.set(origin);
        }
        String origin = (String)last.get();
        if (!sequence.isEmpty()) {
            Grammar group = this.builder.createMatchAll(sequence, origin);
            sequence.clear();
            choices.add(group);
        }
        if (previous.isOpenChoice()) {
            return this.builder.createMatchFirst(choices, origin);
        }
        return this.builder.createMatchBest(choices, origin);
    }

    private Grammar next(RuleIterator iterator, RuleType previous) {
        Rule rule = iterator.peek();
        RuleType type = rule.getType();
        String origin = rule.getOrigin();
        String text = rule.getSymbol();
        if (type.isSpace()) {
            return this.builder.createSpace(text, origin);
        }
        if (type.isLiteral()) {
            return this.builder.createLiteral(text, origin);
        }
        if (type.isReference()) {
            return this.builder.createReference(text, origin);
        }
        if (type.isSpecial()) {
            return this.builder.createSpecial(text, origin);
        }
        return null;
    }

    private Grammar consume(RuleIterator iterator, RuleType previous) {
        Rule rule = iterator.peek();
        RuleType type = rule.getType();
        if (type.isToken()) {
            return this.sequence(iterator, previous);
        }
        if (type.isOpenGroup() || type.isOpenChoice()) {
            return this.group(iterator, type);
        }
        if (type.isOptional()) {
            return this.optional(iterator, previous);
        }
        if (type.isRepeat() || type.isRepeatOnce()) {
            return this.repeat(iterator, previous);
        }
        return null;
    }
}

