/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import java.util.Map;
import org.snapscript.common.LeastRecentlyUsedMap;
import org.snapscript.parse.SourceCode;
import org.snapscript.parse.SourceCompressor;
import org.snapscript.parse.SourceException;

public class SourceProcessor {
    private final Map<String, SourceCode> cache = new LeastRecentlyUsedMap<String, SourceCode>();
    private final int limit;

    public SourceProcessor(int limit) {
        this.limit = limit;
    }

    public SourceCode process(String source) {
        char[] text = source.toCharArray();
        if (text.length == 0) {
            throw new SourceException("Source text is empty");
        }
        SourceCompressor compressor = new SourceCompressor(text);
        if (text.length < this.limit) {
            SourceCode code = this.cache.get(source);
            if (code == null) {
                code = compressor.compress();
                this.cache.put(source, code);
            }
            return code;
        }
        return compressor.compress();
    }
}

