/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import java.util.HashMap;
import java.util.Map;

public class StringInterner {
    private final Map<Range, String> cache = new HashMap<Range, String>();
    private final String empty = new String();

    public String intern(char[] source) {
        return this.intern(source, 0, source.length);
    }

    public String intern(char[] source, int start, int length) {
        Range key = new Range(source, start, length);
        if (length > 0) {
            String value = this.cache.get(key);
            if (value == null) {
                String text = key.toString();
                String internal = text.intern();
                this.cache.put(key, internal);
                return internal;
            }
            return value;
        }
        return this.empty;
    }

    private class Range {
        private char[] source;
        private int start;
        private int length;
        private int hash;

        public Range(char[] source, int start, int length) {
            this.source = source;
            this.length = length;
            this.start = start;
        }

        public int hashCode() {
            if (this.hash == 0) {
                for (int i = 0; i < this.length; ++i) {
                    this.hash = 31 * this.hash + this.source[i + this.start];
                }
            }
            return this.hash;
        }

        public boolean equals(Object value) {
            Range key = (Range)value;
            if (this.length != key.length) {
                return false;
            }
            if (this.hash != key.hash) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.source[i + this.start] == key.source[i + key.start]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return new String(this.source, this.start, this.length);
        }
    }
}

