/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

public abstract class StringParser {
    protected char[] source = new char[0];
    protected int off;
    protected int count;

    protected StringParser() {
    }

    public void parse(String text) {
        if (text != null) {
            this.ensureCapacity(text.length());
            this.count = text.length();
            text.getChars(0, this.count, this.source, 0);
            this.init();
            this.parse();
        }
    }

    public void parse(char[] text) {
        this.parse(text, 0, text.length);
    }

    public void parse(char[] text, int off, int len) {
        if (text != null) {
            this.ensureCapacity(len);
            this.count = len;
            System.arraycopy(text, off, this.source, 0, len);
            this.init();
            this.parse();
        }
    }

    protected void ensureCapacity(int min) {
        if (this.source.length < min) {
            int size = this.source.length * 2;
            int max = Math.max(min, size);
            char[] temp = new char[max];
            this.source = temp;
        }
    }

    protected boolean space(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    protected boolean quote(char c) {
        return c == '\"' || c == '\'';
    }

    protected boolean digit(char c) {
        return c <= '9' && '0' <= c;
    }

    protected char toLower(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c - 65 + 97);
        }
        return c;
    }

    protected boolean skip(String text) {
        int size = text.length();
        int read = 0;
        if (this.off + size > this.count) {
            return false;
        }
        while (read < size) {
            char a = text.charAt(read);
            char b = this.source[this.off + read++];
            if (this.toLower(a) == this.toLower(b)) continue;
            return false;
        }
        this.off += size;
        return true;
    }

    protected boolean seek(String text) {
        char next;
        int seek = 0;
        while (seek + this.off < this.count && this.space(next = this.source[this.off + seek])) {
            ++seek;
        }
        int size = text.length();
        int read = 0;
        if (this.off + size > this.count) {
            return false;
        }
        while (read < size) {
            char a = text.charAt(read);
            char b = this.source[this.off + seek + read++];
            if (this.toLower(a) == this.toLower(b)) continue;
            return false;
        }
        this.off += size + seek;
        return true;
    }

    protected abstract void init();

    protected abstract void parse();
}

