/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import org.snapscript.parse.Grammar;
import org.snapscript.parse.GrammarCache;
import org.snapscript.parse.GrammarIndexer;
import org.snapscript.parse.GrammarMatcher;
import org.snapscript.parse.GrammarResolver;
import org.snapscript.parse.SyntaxBuilder;
import org.snapscript.parse.SyntaxChecker;
import org.snapscript.parse.SyntaxNode;
import org.snapscript.parse.SyntaxTree;
import org.snapscript.parse.SyntaxTreeBuilder;

public class SyntaxParser {
    private final SyntaxTreeBuilder builder;
    private final GrammarResolver resolver;

    public SyntaxParser(GrammarResolver resolver, GrammarIndexer indexer) {
        this.builder = new SyntaxTreeBuilder(indexer);
        this.resolver = resolver;
    }

    public SyntaxNode parse(String resource, String expression, String name) {
        GrammarCache cache = new GrammarCache();
        if (expression == null) {
            throw new IllegalArgumentException("Expression for '" + resource + "' is null");
        }
        Grammar grammar = this.resolver.resolve(name);
        if (grammar == null) {
            throw new IllegalArgumentException("Grammar '" + name + "' is not defined");
        }
        SyntaxTree tree = this.builder.create(resource, expression, name);
        int length = tree.length();
        if (length > 0) {
            SyntaxChecker checker;
            GrammarMatcher matcher = grammar.create(cache, length);
            if (matcher.check(checker = tree.check(), 0)) {
                SyntaxBuilder builder = tree.build();
                if (matcher.build(builder, 0)) {
                    builder.commit();
                    return tree.commit();
                }
                throw new IllegalArgumentException("Grammar '" + name + "' failed to build");
            }
            checker.validate();
        }
        return null;
    }
}

