/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.parse.GrammarIndexer;
import org.snapscript.parse.LexicalAnalyzer;
import org.snapscript.parse.Line;
import org.snapscript.parse.ParseException;
import org.snapscript.parse.PositionStack;
import org.snapscript.parse.SyntaxBuilder;
import org.snapscript.parse.SyntaxChecker;
import org.snapscript.parse.SyntaxNode;
import org.snapscript.parse.SyntaxNodeComparator;
import org.snapscript.parse.Token;
import org.snapscript.parse.TokenConsumer;
import org.snapscript.parse.TokenScanner;

public class SyntaxTree {
    private final Comparator<SyntaxNode> comparator;
    private final List<SyntaxCursor> nodes;
    private final LexicalAnalyzer analyzer;
    private final GrammarIndexer indexer;
    private final AtomicInteger commit;
    private final PositionStack stack;
    private final String resource;
    private final String grammar;
    private final int length;

    public SyntaxTree(GrammarIndexer indexer, String resource, String grammar, char[] original, char[] source, short[] lines, short[] types) {
        this.analyzer = new TokenScanner(indexer, resource, original, source, lines, types);
        this.comparator = new SyntaxNodeComparator();
        this.nodes = new LinkedList<SyntaxCursor>();
        this.commit = new AtomicInteger();
        this.stack = new PositionStack();
        this.length = source.length;
        this.resource = resource;
        this.indexer = indexer;
        this.grammar = grammar;
    }

    public SyntaxChecker check() {
        int index = this.indexer.index(this.grammar);
        int depth = this.stack.depth(0, index);
        if (depth >= 0) {
            throw new ParseException("Syntax has been validated");
        }
        this.stack.push(0, index);
        return new SyntaxValidator(this.analyzer);
    }

    public SyntaxBuilder build() {
        int count;
        int index = this.indexer.index(this.grammar);
        int mark = this.analyzer.mark();
        if (mark != (count = this.analyzer.count())) {
            int error = this.commit.get();
            Line line = this.analyzer.line(error);
            if (this.resource != null) {
                throw new ParseException("Syntax error in '" + this.resource + "' at line " + line);
            }
            throw new ParseException("Syntax error at line " + line);
        }
        this.analyzer.reset(0);
        this.stack.clear();
        this.stack.push(0, index);
        return new SyntaxCursor(this.analyzer, this.nodes, index, 0);
    }

    public SyntaxNode commit() {
        int size = this.nodes.size();
        if (size > 2) {
            throw new ParseException("Syntax tree has more than one root");
        }
        SyntaxCursor cursor = this.nodes.get(0);
        SyntaxNode node = cursor.create();
        if (node == null) {
            throw new ParseException("Syntax tree has no root");
        }
        return node;
    }

    public int length() {
        return this.length;
    }

    private class SyntaxResult
    implements SyntaxNode {
        private List<SyntaxCursor> nodes;
        private Token token;
        private int grammar;
        private int start;

        public SyntaxResult(List<SyntaxCursor> nodes, Token token, int grammar, int start) {
            this.grammar = grammar;
            this.token = token;
            this.start = start;
            this.nodes = nodes;
        }

        @Override
        public List<SyntaxNode> getNodes() {
            int size = this.nodes.size();
            if (size > 0) {
                ArrayList<SyntaxNode> result = new ArrayList<SyntaxNode>(size);
                for (SyntaxCursor child : this.nodes) {
                    SyntaxNode node = child.create();
                    if (node == null) continue;
                    result.add(node);
                }
                if (size > 1) {
                    Collections.sort(result, SyntaxTree.this.comparator);
                }
                return result;
            }
            return Collections.emptyList();
        }

        @Override
        public String getGrammar() {
            return SyntaxTree.this.indexer.value(this.grammar);
        }

        @Override
        public Line getLine() {
            return SyntaxTree.this.analyzer.line(this.start);
        }

        @Override
        public Token getToken() {
            return this.token;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        public String toString() {
            return SyntaxTree.this.indexer.value(this.grammar);
        }
    }

    private class SyntaxCursor
    extends TokenConsumer
    implements SyntaxBuilder {
        private final List<SyntaxCursor> parent;
        private final List<SyntaxCursor> nodes = new LinkedList<SyntaxCursor>();
        private final int grammar;
        private final int start;

        public SyntaxCursor(LexicalAnalyzer analyzer, List<SyntaxCursor> parent, int grammar, int start) {
            this.analyzer = analyzer;
            this.grammar = grammar;
            this.parent = parent;
            this.start = start;
        }

        public SyntaxNode create() {
            return new SyntaxResult(this.nodes, this.value, this.grammar, this.start);
        }

        @Override
        public SyntaxBuilder mark(int grammar) {
            int off = this.analyzer.mark();
            int index = SyntaxTree.this.stack.depth(off, grammar);
            if (index <= 0) {
                SyntaxTree.this.stack.push(off, grammar);
                return new SyntaxCursor(this.analyzer, this.nodes, grammar, off);
            }
            return null;
        }

        @Override
        public int reset() {
            int mark = this.analyzer.mark();
            SyntaxTree.this.stack.pop(this.start, this.grammar);
            this.analyzer.reset(this.start);
            return mark;
        }

        @Override
        public void commit() {
            int mark = this.analyzer.mark();
            int error = SyntaxTree.this.commit.get();
            int value = SyntaxTree.this.stack.pop(this.start, this.grammar);
            if (value != -1) {
                if (mark > error) {
                    SyntaxTree.this.commit.set(mark);
                }
                this.parent.add(this);
            }
        }

        @Override
        public int position() {
            return this.analyzer.mark();
        }

        @Override
        public int peek() {
            return this.analyzer.peek();
        }
    }

    private class SyntaxValidator
    extends TokenConsumer
    implements SyntaxChecker {
        public SyntaxValidator(LexicalAnalyzer analyzer) {
            this.analyzer = analyzer;
        }

        @Override
        public void validate() {
            int count;
            int mark = this.analyzer.mark();
            if (mark != (count = this.analyzer.count())) {
                int error = SyntaxTree.this.commit.get();
                Line line = this.analyzer.line(error);
                if (SyntaxTree.this.resource != null) {
                    throw new ParseException("Syntax error in '" + SyntaxTree.this.resource + "' at line " + line);
                }
                throw new ParseException("Syntax error at line " + line);
            }
        }

        @Override
        public int mark(int grammar) {
            int off = this.analyzer.mark();
            int index = SyntaxTree.this.stack.depth(off, grammar);
            if (index <= 0) {
                SyntaxTree.this.stack.push(off, grammar);
                return off;
            }
            return -1;
        }

        @Override
        public int reset(int start, int grammar) {
            int mark = this.analyzer.mark();
            SyntaxTree.this.stack.pop(start, grammar);
            this.analyzer.reset(start);
            return mark;
        }

        @Override
        public void commit(int start, int grammar) {
            int mark = this.analyzer.mark();
            int error = SyntaxTree.this.commit.get();
            int value = SyntaxTree.this.stack.pop(start, grammar);
            if (value != -1 && mark > error) {
                SyntaxTree.this.commit.set(mark);
            }
        }

        @Override
        public int position() {
            return this.analyzer.mark();
        }

        @Override
        public int peek() {
            return this.analyzer.peek();
        }
    }
}

